package org.msh.tb.bd.dashboard.summaryrep.parser;

import org.msh.tb.bd.dashboard.DashboardIndicatorUtils;
import org.msh.tb.bd.dashboard.summaryrep.data.IndicatorRateData;
import org.msh.tb.bd.dashboard.summaryrep.data.SummaryIndicatorData;
import org.msh.utils.date.DateUtils;
import org.msh.utils.date.Period;

import java.util.Date;
import java.util.List;

/**
 * Created by mauri on 23/05/2017.
 * Parses information returned from IndicatorQuery to a SummaryIndicatorData object
 */
public class Indicator08Parser implements IndicatorParser {

    /**
     * The indicator code like 'indicator01' used by UI to generate some components
     */
    private String indicatorCode;

    public Indicator08Parser(String indicatorCode) {
        this.indicatorCode = indicatorCode;
    }

    @Override
    public SummaryIndicatorData parse(List<Object[]> result, String locationDesc) {
        SummaryIndicatorData data = new SummaryIndicatorData(locationDesc, "dashboard.last12months", "indicator08");
        long total = 0;

        for (Object[] o : result) {
            if (o[2] != null) {
                total = total + (Long)o[2];
            }
        }

        for (Object[] o : result) {
            String fv = (String) o[1];
            Long val = (Long) o[2];

            data.addIndicatorRate(DashboardIndicatorUtils.calcPercentage(val, total), "%", fv);
        }

        return data;
    }

    @Override
    public Period getPeriod() {
        return DashboardIndicatorUtils.getLast12MonthsPeriod();
    }

    @Override
    public SummaryIndicatorData parse(List<Object[]> result, String locationDesc, SummaryIndicatorData nationalResult) {
        SummaryIndicatorData data = parse(result, locationDesc);

        for (IndicatorRateData rateData : data.getIndicatorRates()) {
            for (IndicatorRateData natRateData : nationalResult.getIndicatorRates()){

                if (natRateData.getRateDescMsg() != null && rateData.getRateDescMsg() != null &&
                        natRateData.getRateDescMsg().equals(rateData.getRateDescMsg())) {
                    rateData.setNationalRate(natRateData.getRate());
                    break;
                }
            }
        }

        return data;
    }

    public String getIndicatorCode() {
        return indicatorCode;
    }

    public void setIndicatorCode(String indicatorCode) {
        this.indicatorCode = indicatorCode;
    }
}
